/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.exprcomp;

import filenet.vw.api.VWException;
import filenet.vw.base.exprcomp.IField;
import filenet.vw.base.exprcomp.IFieldCollection;
import filenet.vw.base.exprcomp.OpCode;
import java.util.Hashtable;
import java.util.Stack;

class MiscellaneousOp
extends OpCode {
    public MiscellaneousOp(int miscOpCode) {
        super(miscOpCode);
    }

    public int dispatch(Stack runStack, IFieldCollection mainFields, IFieldCollection alternateFields, Hashtable envData) throws Exception {
        switch (this.opCode) {
            case 2: {
                this.doBeginSubScript(runStack);
                break;
            }
            case 14: {
                this.doSubScript(runStack);
                break;
            }
            case 90: {
                this.doEndSubScript(runStack);
                break;
            }
            case 7: {
                this.doFieldDefined1Func(runStack, mainFields);
                break;
            }
            case 84: {
                this.doAltFieldDefinedFunc(runStack, alternateFields);
                break;
            }
            default: {
                throw new VWException("vw.base.ExpressionExecution.BadOpCode", "***Opcode ({0}) not implemented.", this.toString());
            }
        }
        return -1;
    }

    private void doBeginSubScript(Stack runStack) {
    }

    private void doEndSubScript(Stack runStack) {
    }

    private void doSubScript(Stack runStack) throws Exception {
        int index = (Integer)runStack.pop();
        String arrayName = (String)runStack.pop();
        IFieldCollection fields = (IFieldCollection)runStack.pop();
        IField arrayField = fields.getField(arrayName);
        if (!arrayField.isArray()) {
            throw new VWException("vw.base.ExpressionExecution.IndexNonArray", "attempt to index non-array field {0}", arrayName);
        }
        if (index <= 0 || index > ((Object[])arrayField.getValue()).length) {
            throw new VWException("vw.base.ExpressionExecution.ArraySubScriptOutOfBounds", "array subscript out of range [{0}]", String.valueOf(index));
        }
        runStack.push(arrayField.getValue());
        runStack.push(new Integer(index - 1));
    }

    private void doFieldDefined1Func(Stack runStack, IFieldCollection mainFields) {
        String fieldNameStr = (String)runStack.pop();
        try {
            mainFields.getField(fieldNameStr);
            runStack.push(new Boolean(true));
        }
        catch (Exception e) {
            runStack.push(new Boolean(false));
        }
    }

    private void doAltFieldDefinedFunc(Stack runStack, IFieldCollection altFields) {
        String fieldNameStr = (String)runStack.pop();
        try {
            altFields.getField(fieldNameStr);
            runStack.push(new Boolean(true));
        }
        catch (Exception e) {
            runStack.push(new Boolean(false));
        }
    }
}

